﻿' ChangeLanguage, Version 1.0.0, vom 20.09.2010
'
' Action zum ändern der Spracheinstellungen im aktuellen Projekt
'
' Copyright by Frank Schöneck, 2010
' letzte Änderung: Frank Schöneck, 17.09.2010 V1.0.0, Projektbeginn
'
' für Eplan Electric P8, ab V2.0.5
'
' Aufruf als CommandLineInterpreter: ChangeLanguage /varLANGUAGE:de_DE /dispLANGUAGE:de_DE;en_EN;
'  /varLANGUAGE: = Einstellung der Sprache für Einsprachig(variabel)
'  /dispLANGUAGE: = Einstellung der Anzeige Sprachen (Wichtig Sprachkennung muß mit ";" abgeschlossen sein !)

Imports System.IO

Public Class ChangeLanguage
	<DeclareAction("ChangeLanguage")> _
	Public Sub SetChangeLanguage(varLANGUAGE as String, dispLANGUAGE as String)
		Dim strSettingsDatei as String = PathMap.SubstitutePath("$(TMP)") & "\ChangeLanguage.xml"
		Dim strProject as String = PathMap.SubstitutePath("$(CURRENT_PROJECTPATH)")
		Dim objDateiMacher As StreamWriter
		
		'Settings-Datei schreiben
		objDateiMacher = New StreamWriter(strSettingsDatei)
		objDateiMacher.WriteLine("<?xml version=""1.0"" encoding=""utf-8"" ?>")
		objDateiMacher.WriteLine("<Settings ver=""2.0.5"">")
		objDateiMacher.WriteLine(" <CAT name=""PROJECT"">")
		objDateiMacher.WriteLine("  <MOD name=""TRANSLATEGUI"">")
		objDateiMacher.WriteLine("   <Setting name=""VAR_LANGUAGE"" ver=""1"" type=""string"" desc=""518"">")
		objDateiMacher.WriteLine("    <Val>" & varLANGUAGE & "</Val>")
		objDateiMacher.WriteLine("   </Setting>")
		objDateiMacher.WriteLine("   <Setting name=""DISPLAYED_LANGUAGES"" ver=""1"" type=""string"" desc=""510"">")
		objDateiMacher.WriteLine("    <Val>" & dispLANGUAGE & "</Val>")
		objDateiMacher.WriteLine("   </Setting>")
		objDateiMacher.WriteLine("  </MOD>")
		objDateiMacher.WriteLine(" </CAT>")
		objDateiMacher.WriteLine("</Settings>")
		objDateiMacher.Close()
		objDateiMacher = Nothing
		
		'Settings-Datei in aktuelles Projekt importieren
		Dim CommandLineInterpreter As New CommandLineInterpreter()
		CommandLineInterpreter.Execute("XSettingsImport /XMLFile:""" & strSettingsDatei & """ /Project:""" & strProject & "")
		
		'Anzeige aktualiesieren
		CommandLineInterpreter.Execute("XGedRedrawAction")
		
		'Datei löschen
		If File.Exists(strSettingsDatei) Then File.Delete(strSettingsDatei)
		
	End Sub
End Class
