﻿using System.Collections.Generic;
using System.Text;
using Eplan.EplApi.Gui;
using System.IO;
using System.Collections;
using System.Diagnostics;
using System.Globalization;
//using System;
//using System.Windows.Forms;

public class FrmSearchMacros : System.Windows.Forms.Form
{
    // Variablen
    public string sProjectsPath = string.Empty; 
    public ArrayList arrProjectsDirectories = new ArrayList();
    private System.Windows.Forms.StatusStrip statusStrip1;
    private System.Windows.Forms.ToolStripProgressBar prgBar;
    private System.Windows.Forms.Label lblStatus;

    // Formular (Programmdateien zur Generierung des Forms)
    #region Formular
    public FrmSearchMacros()
    {
        InitializeComponent();
    }

    // ListView: Sortierung
    class ListViewItemComparer : IComparer
    {
        private int col;
        public ListViewItemComparer()
        {
            col = 0;
        }
        public ListViewItemComparer(int column)
        {
            col = column;
        }
        public int Compare(object x, object y)
        {
            int returnVal = -1;
            returnVal = String.Compare(((ListViewItem)x).SubItems[col].Text,
            ((ListViewItem)y).SubItems[col].Text);
            return returnVal;
        }
    }

    private System.Windows.Forms.Button btnAbbrechen;
    private System.Windows.Forms.ToolStripStatusLabel lblStatus2;
    private System.Windows.Forms.Button btnOK;
    private System.Windows.Forms.Button btnOpenProject;
    private System.Windows.Forms.ListView liviResult;
    private System.Windows.Forms.ColumnHeader columnHeader1;
    private System.Windows.Forms.ColumnHeader columnHeader2;
    private System.Windows.Forms.ColumnHeader columnHeader3;
    private System.Windows.Forms.Button btnSearch;
    private System.Windows.Forms.TextBox txtSearch;


    ///
    /// Erforderliche Designervariable.
    ///
    private System.ComponentModel.IContainer components = null;

    ///
    /// Verwendete Ressourcen bereinigen.
    ///
    /// True, wenn verwaltete Ressourcen gelöscht werden sollen; andernfalls False.
    protected override void Dispose(bool disposing)
    {
        if (disposing && (components != null))
        {
            components.Dispose();
        }
        base.Dispose(disposing);
    }

    #region Vom Windows Form-Designer generierter Code

    ///
    /// Erforderliche Methode für die Designerunterstützung.
    /// Der Inhalt der Methode darf nicht mit dem Code-Editor geändert werden.
    ///
    private void InitializeComponent()
    {
        this.btnAbbrechen = new System.Windows.Forms.Button();
        this.lblStatus2 = new System.Windows.Forms.ToolStripStatusLabel();
        this.btnOK = new System.Windows.Forms.Button();
        this.btnOpenProject = new System.Windows.Forms.Button();
        this.liviResult = new System.Windows.Forms.ListView();
        this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
        this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
        this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
        this.btnSearch = new System.Windows.Forms.Button();
        this.txtSearch = new System.Windows.Forms.TextBox();
        this.statusStrip1 = new System.Windows.Forms.StatusStrip();
        this.prgBar = new System.Windows.Forms.ToolStripProgressBar();
        this.lblStatus = new System.Windows.Forms.Label();
        this.statusStrip1.SuspendLayout();
        this.SuspendLayout();
        // 
        // btnAbbrechen
        // 
        this.btnAbbrechen.DialogResult = System.Windows.Forms.DialogResult.Cancel;
        this.btnAbbrechen.Location = new System.Drawing.Point(510, 246);
        this.btnAbbrechen.Name = "btnAbbrechen";
        this.btnAbbrechen.Size = new System.Drawing.Size(72, 24);
        this.btnAbbrechen.TabIndex = 7;
        this.btnAbbrechen.Text = "Abbrechen";
        this.btnAbbrechen.UseVisualStyleBackColor = true;
        // 
        // lblStatus2
        // 
        this.lblStatus2.Margin = new System.Windows.Forms.Padding(2, 3, 0, 2);
        this.lblStatus2.Name = "lblStatus2";
        this.lblStatus2.Size = new System.Drawing.Size(235, 17);
        this.lblStatus2.Text = "Letzte Änderung: 2009-10-23  - Johann Weiher";
        // 
        // btnOK
        // 
        this.btnOK.Location = new System.Drawing.Point(429, 246);
        this.btnOK.Name = "btnOK";
        this.btnOK.Size = new System.Drawing.Size(75, 23);
        this.btnOK.TabIndex = 6;
        this.btnOK.Text = "OK";
        this.btnOK.UseVisualStyleBackColor = true;
        this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
        // 
        // btnOpenProject
        // 
        this.btnOpenProject.Location = new System.Drawing.Point(558, 9);
        this.btnOpenProject.Name = "btnOpenProject";
        this.btnOpenProject.Size = new System.Drawing.Size(24, 23);
        this.btnOpenProject.TabIndex = 11;
        this.btnOpenProject.Text = "...";
        this.btnOpenProject.UseVisualStyleBackColor = true;
        this.btnOpenProject.Click += new System.EventHandler(this.btnOpenProject_Click);
        // 
        // liviResult
        // 
        this.liviResult.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader3});
        this.liviResult.FullRowSelect = true;
        this.liviResult.GridLines = true;
        this.liviResult.HideSelection = false;
        this.liviResult.Location = new System.Drawing.Point(12, 39);
        this.liviResult.Name = "liviResult";
        this.liviResult.Size = new System.Drawing.Size(570, 201);
        this.liviResult.TabIndex = 10;
        this.liviResult.UseCompatibleStateImageBehavior = false;
        this.liviResult.View = System.Windows.Forms.View.Details;
        this.liviResult.DoubleClick += new System.EventHandler(this.liviResult_DoubleClick);
        this.liviResult.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.liviResult_ColumnClick);
        // 
        // columnHeader1
        // 
        this.columnHeader1.Text = "Projekt";
        this.columnHeader1.Width = 76;
        // 
        // columnHeader2
        // 
        this.columnHeader2.Text = "Pfad";
        this.columnHeader2.Width = 89;
        // 
        // columnHeader3
        // 
        this.columnHeader3.Text = "Erweiterung";
        this.columnHeader3.Width = 223;
        // 
        // btnSearch
        // 
        this.btnSearch.Enabled = false;
        this.btnSearch.Location = new System.Drawing.Point(477, 9);
        this.btnSearch.Name = "btnSearch";
        this.btnSearch.Size = new System.Drawing.Size(75, 23);
        this.btnSearch.TabIndex = 9;
        this.btnSearch.Text = "Suchen";
        this.btnSearch.UseVisualStyleBackColor = true;
        this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
        // 
        // txtSearch
        // 
        this.txtSearch.Location = new System.Drawing.Point(12, 11);
        this.txtSearch.Name = "txtSearch";
        this.txtSearch.Size = new System.Drawing.Size(459, 20);
        this.txtSearch.TabIndex = 8;
        this.txtSearch.TextChanged += new System.EventHandler(this.txtSearch_TextChanged);
        // 
        // statusStrip1
        // 
        this.statusStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.prgBar});
        this.statusStrip1.Location = new System.Drawing.Point(0, 273);
        this.statusStrip1.Name = "statusStrip1";
        this.statusStrip1.Size = new System.Drawing.Size(594, 22);
        this.statusStrip1.SizingGrip = false;
        this.statusStrip1.TabIndex = 13;
        this.statusStrip1.Text = "statusStrip1";
        // 
        // prgBar
        // 
        this.prgBar.AutoSize = false;
        this.prgBar.Name = "prgBar";
        this.prgBar.Size = new System.Drawing.Size(590, 16);
        // 
        // lblStatus
        // 
        this.lblStatus.Location = new System.Drawing.Point(9, 246);
        this.lblStatus.Name = "lblStatus";
        this.lblStatus.Size = new System.Drawing.Size(414, 23);
        this.lblStatus.TabIndex = 14;
        this.lblStatus.Text = "xxx";
        this.lblStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
        // 
        // FrmSearchMacros
        // 
        this.AcceptButton = this.btnSearch;
        this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
        this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
        this.BackColor = System.Drawing.SystemColors.Control;
        this.CancelButton = this.btnAbbrechen;
        this.ClientSize = new System.Drawing.Size(594, 295);
        this.Controls.Add(this.lblStatus);
        this.Controls.Add(this.statusStrip1);
        this.Controls.Add(this.btnOpenProject);
        this.Controls.Add(this.liviResult);
        this.Controls.Add(this.btnSearch);
        this.Controls.Add(this.txtSearch);
        this.Controls.Add(this.btnOK);
        this.Controls.Add(this.btnAbbrechen);
        this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
        this.MaximizeBox = false;
        this.MaximumSize = new System.Drawing.Size(800, 800);
        this.MinimizeBox = false;
        this.Name = "FrmSearchMacros";
        this.ShowIcon = false;
        this.ShowInTaskbar = false;
        this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
        this.Text = "SearchProjects © Johann Weiher";
        this.Load += new System.EventHandler(this.FrmSearchMacros_Load);
        this.statusStrip1.ResumeLayout(false);
        this.statusStrip1.PerformLayout();
        this.ResumeLayout(false);
        this.PerformLayout();

    }

    #endregion


    # endregion // Code für das Formular

    // Menü
    [DeclareMenu]
    public void MenuFunction()
    {
        Eplan.EplApi.Gui.Menu oMenu = new Eplan.EplApi.Gui.Menu();
        oMenu.AddMenuItem
            (
            "Projekt suchen...",
            "SearchProjects",
            "Projekt(e) suchen und öffnen",
            35002,
            1,
            false,
            false
            );
    }

    // Action initialisieren
    [DeclareAction("SearchProjects")]

    // Dialog aufrufen
    public void SearchMacrosVoid()
    {
        FrmSearchMacros Frm1 = new FrmSearchMacros();
        Frm1.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
        Frm1.ShowDialog();
        return;

    }

    // Form: Load
    private void FrmSearchMacros_Load(object sender, System.EventArgs e)
    {
        //sProjectsPath = @"C:\Projekte\";
        sProjectsPath = PathMap.SubstitutePath("$(MD_PROJECTS)"); // Optional kann hier ein anderer Projektpfad eingetragen werden
        lblStatus.Text = "";
        txtSearch.Select();
    }

    // Button: Abbrechen
    private void btnAbbrechen_Click(object sender, System.EventArgs e)
    {
        Close();
    }

    // Button: OpenProject
    private void btnOpenProject_Click(object sender, System.EventArgs e)
    {
        OpenFileDialog openFileDlg = new OpenFileDialog();
        openFileDlg.Filter = "Projektdatei (*.el*)|*.el*|Alle Dateien anzeigen|*.*";
        openFileDlg.Multiselect = true;
        openFileDlg.InitialDirectory = sProjectsPath;

        // Fileopen
        if (openFileDlg.ShowDialog() == DialogResult.OK)
        {
            this.Update();
            prgBar.Maximum = openFileDlg.FileNames.Length;
            // Dateien einlesen
            foreach (string s in openFileDlg.FileNames)
            {
                prgBar.Value += 1;
                this.Update();
                Eplan_OpenProject(s);
            }
            prgBar.Value = 0;
        }
        this.Close();
    }

    // Button: Suchen
    private void btnSearch_Click(object sender, System.EventArgs e)
    {
        // Anzeige
            Cursor.Current = Cursors.WaitCursor;
            lblStatus.Text = "";
            liviResult.BeginUpdate();
            
            // Suchen
            GetProjects();
            //OpenOrSelectProject(); // Einkommentieren wenn Projekt sofort geöffnet werden soll

            // Anzeige
            for (int i = 0; i <= liviResult.Columns.Count - 1; i++)
            {
                liviResult.Columns[i].Width = -2;
            }
            liviResult.EndUpdate();
            prgBar.Value = 0;
            Cursor.Current = Cursors.Default;

    }

    // Button: OK
    private void btnOK_Click(object sender, System.EventArgs e)
    {
        prgBar.Maximum = liviResult.SelectedItems.Count;
        foreach (ListViewItem item in liviResult.SelectedItems)
        {
            prgBar.Value += 1;
            string s = item.SubItems[1].Text + item.SubItems[0].Text + item.SubItems[2].Text;
            Eplan_OpenProject(s);
        }
        prgBar.Value = 0;
        this.Close();
    }

    // ListView: Ergebnis anzeigen
    private void FillListView(string Fullpath)
    {
        if (!Fullpath.Contains(".edb"))
        {
            if (!Fullpath.Contains("_elkfile.elk"))
            {
                FileInfo fi = new FileInfo(Fullpath);
                ListViewItem liviItem = new ListViewItem();
                liviItem.Text = Path.GetFileNameWithoutExtension(fi.FullName);
                liviItem.SubItems.Add(fi.Directory.ToString() + @"\");
                liviItem.SubItems.Add(fi.Extension.ToString());
                liviResult.Items.Add(liviItem);
            }


        }
    }

    // ListView: Sortieren
    private void liviResult_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
    {
        this.liviResult.ListViewItemSorter = new ListViewItemComparer(e.Column);
        liviResult.Sort();
    }

    // ListView: Doppelklick
    private void liviResult_DoubleClick(object sender, EventArgs e)
    {
        string s = liviResult.SelectedItems[0].SubItems[1].Text + liviResult.SelectedItems[0].SubItems[0].Text + liviResult.SelectedItems[0].SubItems[2].Text;
        Eplan_OpenProject(s);
        this.Close();
    }

    // Methode: Erste Ebene nach Suchbegriff durchsuchen & EPLAN-Dateien einlesen
    private void GetProjects()
    {
        // Anzeige
        arrProjectsDirectories.Clear();
        liviResult.Items.Clear();

        // Projektordner finden
        foreach (string d in System.IO.Directory.GetDirectories(sProjectsPath, "*" + txtSearch.Text + "*", SearchOption.TopDirectoryOnly))
        {
            arrProjectsDirectories.Add(d);
        }
        prgBar.Maximum = arrProjectsDirectories.Count;
        int iMax = arrProjectsDirectories.Count;
        int iVal = 0;

        // Projektdateien finden
        foreach (string d in arrProjectsDirectories)
        {
            prgBar.Value += 1;
            iVal += 1;
            lblStatus.Text = "Durchsuche Ordner " + iVal.ToString() + " von " + iMax.ToString();
            this.Update();

            foreach (string f in System.IO.Directory.GetFiles(d, "*.elk*", SearchOption.AllDirectories))
            {
                FillListView(f);
            }
            foreach (string f in System.IO.Directory.GetFiles(d, "*.elr*", SearchOption.AllDirectories))
            {
                FillListView(f);
            }
        }
        lblStatus.Text = "Projekte gefunden: " + liviResult.Items.Count.ToString();

    }

    // Methode: Projekt wird sofort geöffnet wenn nur eins gefunden wird
    private void OpenOrSelectProject()
    {
        switch (liviResult.Items.Count)
        {
            case 1:
                string s = liviResult.Items[0].SubItems[1].Text + liviResult.Items[0].SubItems[0].Text + liviResult.Items[0].SubItems[2].Text;
                Eplan_OpenProject(s);
                break;
            default:
                break;
        }

    }

    // Methode: Eplan Action: ProjectOpen
    private void Eplan_OpenProject(string FullProjectPath)
    {
        lblStatus.Text = "Projekt öffnen: " + System.IO.Path.GetFileNameWithoutExtension(FullProjectPath);
        lblStatus.Update();
        ActionCallingContext AccOpen = new ActionCallingContext();
        AccOpen.AddParameter("Project", FullProjectPath);
        new CommandLineInterpreter().Execute("ProjectOpen", AccOpen);
        lblStatus.Text = "";
    }

    private void txtSearch_TextChanged(object sender, System.EventArgs e)
    {
        if (txtSearch.Text == "")
        {
            btnSearch.Enabled = false;
        }
        else
        {
            btnSearch.Enabled = true;
        }
    }


}





