﻿public class ImportProjectProperties
{
    [DeclareAction("ImportProjectProperties")]
    public void ProjectPropertiesVoid()
    {
        ////////////////////////////////////////////////////////////////////////
        // Projektdaten
        ////////////////////////////////////////////////////////////////////////
        string sSelectedProjectData = string.Empty;     // kompletter Pfad + Projektdateinamen + Erweiterung
        string sSelectedProjectPath = string.Empty;     // Projektpfad
        string sSelectedProjectName = string.Empty;     // Projektname

        // Projektdatei komplett
        CommandLineInterpreter oCLI = new CommandLineInterpreter();
        Eplan.EplApi.ApplicationFramework.ActionCallingContext ctx = new Eplan.EplApi.ApplicationFramework.ActionCallingContext();
        ctx.AddParameter("TYPE", "PROJECT");

        bool bRet = oCLI.Execute("selectionset", ctx);
        if (bRet == true)
        {
            ctx.GetParameter("PROJECT", ref sSelectedProjectData);
        }

        // Projektpfad
        sSelectedProjectPath = System.IO.Path.GetDirectoryName(sSelectedProjectData);

        // Projektname
        sSelectedProjectName = System.IO.Path.GetFileNameWithoutExtension(sSelectedProjectData);

        // FileDialog
        OpenFileDialog openFileDlg = new OpenFileDialog();
        openFileDlg.InitialDirectory = sSelectedProjectPath;
        openFileDlg.Filter = "XML-Datei (*.xml)|*.xml|Alle Dateien anzeigen (*.*)|*.*";
        DialogResult result = openFileDlg.ShowDialog();
        if (result == DialogResult.OK)
        {
            // Projecteigenschaften importieren
            ActionCallingContext ccImport = new ActionCallingContext();
            ccImport.AddParameter("TYPE", "READPROJECTINFO");
            ccImport.AddParameter("FILENAME", openFileDlg.FileName);
            oCLI.Execute("projectmanagement", ccImport);
            // Projekteigenschaften aufrufen
            oCLI.Execute("XPrjActionPropertiesEdit");
        }

    }

    // Menü
    [DeclareMenu]
    public void MenuFunction()
    {
        Eplan.EplApi.Gui.Menu oMenu = new Eplan.EplApi.Gui.Menu();
        oMenu.AddMenuItem
            (
            "Projekteigenschaften...",
            "ImportProjectProperties",
            "Projekteigenschaften wiederherstellen...",
            35126,
            1,
            false,
            false
            );
    }

}
