﻿Imports System.Activator
Imports System.Type
Imports System.Runtime.InteropServices
Imports System.IO
Imports System.Reflection


Public Class CompressTranslateDatabase

    <DeclareMenu()> _
   Public Sub CompressTranslateDatabase_Menu()
        Dim oMenu As New Eplan.EplApi.GUI.Menu()
        oMenu.AddMenuItem("Übersetzungsdatenbank komprimieren...", "CompressTranslateDatabase", "Es wird die aktuell eingestellte Übersetzungsdatenbank komprimiert", 35069, 0, False, True)
    End Sub

    <DeclareAction("CompressTranslateDatabase")> _
   Public Sub CompressTranslateDatabase()

        Dim oSettings As New Eplan.EplApi.Base.Settings()
        Dim oPath As New PathMap()
        Dim DatabaseName As String
        Dim DatabaseNameBackup As String
        Dim Result As DialogResult
        Dim boReturn As Boolean
        Dim NewLine As String = Environment.NewLine
        Dim Meldung As String

        'Einstellung 'Übersetzungsdatenbank' auslesen
        DatabaseName = oSettings.getStringSetting("USER.TRANSLATEGUI.DATABASE_NAME", 0)

        'Variablen auslesen und ersetzen
        DatabaseName = oPath.SubstitutePath(DatabaseName)

        'Namen der Backup-Datei festlegen
        DatabaseNameBackup = DatabaseName & ".Backup"

        'Sicherheitsabfrage
        Meldung = "Soll die folgende Übersetzungsdatenbank komprimiert werden?" & NewLine
        Meldung &= NewLine
        Meldung &= "'" & DatabaseName & "'" & NewLine
        Meldung &= NewLine
        Meldung &= "(Es wird im gleichen Ordner eine Sicherheitskopie mit der Dateiendung 'Backup' angelegt.)" & NewLine
        Result = MessageBox.Show(Meldung, "CompressTranslateDatabase", MessageBoxButtons.YesNo, MessageBoxIcon.Question)

        If Result = System.Windows.Forms.DialogResult.Yes Then
            'Artikeldatenbank komprimieren
            boReturn = CompressAccessDataBase(DatabaseName, DatabaseNameBackup)
            'Ergebnismeldung anzeigen
            If boReturn = True Then
                Meldung = "Das komprimieren der Übersetzungsdatenbank wurde erfolgreich durchgeführt." & NewLine
                Meldung &= NewLine
                Meldung &= "Dateigröße vorher: " & GetFileSize(DatabaseNameBackup) & NewLine
                Meldung &= "Dateigröße nachher: " & GetFileSize(DatabaseName) & NewLine
                MessageBox.Show(Meldung, "CompressTranslateDatabase, Information", MessageBoxButtons.OK, MessageBoxIcon.Information)
            ElseIf boReturn = False Then
                MessageBox.Show("Das komprimieren der Übersetzungsdatenbank konnte nicht erfolgreich durchgeführt werden!", "CompressTranslateDatabase, Fehler", MessageBoxButtons.OK, MessageBoxIcon.Error)
            End If
        End If

    End Sub

    'Datenbank komprimieren
    Private Function CompressAccessDataBase(ByVal DatabaseFilename As String, ByVal DatabaseFilenameBackup As String) As Boolean
        Try
            Dim Connection As String = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & DatabaseFilename
            Dim jro As Object = CreateInstance(GetTypeFromProgID("JRO.JetEngine"))
            Dim Params As Object() = _
          New Object() {Connection, "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & _
           DatabaseFilename & ".tmp ;Jet OLEDB:Engine Type=5"}
            jro.GetType().InvokeMember("CompactDatabase", BindingFlags.InvokeMethod, Nothing, jro, Params)

            If File.Exists(DatabaseFilenameBackup) Then File.Delete(DatabaseFilenameBackup)
            File.Move(DatabaseFilename, DatabaseFilenameBackup)
            File.Move(DatabaseFilename & ".tmp", DatabaseFilename)
            Marshal.ReleaseComObject(jro)
            jro = Nothing
            If File.Exists(DatabaseFilenameBackup) Then
                Return True
            Else
                Return False
            End If
        Catch ex As Exception
            MessageBox.Show(ex.InnerException.ToString(), "CompressAccessDataBase, Fehler", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
        Return False
    End Function

    'Anzeige der Dateigröße formatieren
    Private Function GetFileSize(ByVal path As String) As String
        Dim myFile As FileInfo
        Dim mySize As Single

        Try
            myFile = New FileInfo(path)
            If Not myFile.Exists Then
                mySize = 0
            Else
                mySize = myFile.Length
            End If
            Select Case mySize
                Case 0 To 1023
                    Return Microsoft.VisualBasic.Format(mySize, "#,###") & " Bytes"
                Case 1024 To 1048575
                    Return Microsoft.VisualBasic.Format(mySize / 1024, "#,###0.00") & " KB  (" & Microsoft.VisualBasic.Format(mySize, "#,###") & " Bytes)"
                Case 1048576 To 1043741824
                    Return Microsoft.VisualBasic.Format(mySize / 1024 ^ 2, "#,###0.00") & " MB  (" & Microsoft.VisualBasic.Format(mySize, "#,###") & " Bytes)"
                Case Is > 1043741824
                    Return Microsoft.VisualBasic.Format(mySize / 1024 ^ 3, "#,###0.00") & " GB  (" & Microsoft.VisualBasic.Format(mySize, "#,###") & " Bytes)"
            End Select
            Return "0 bytes"
        Catch ex As Exception
            Return "0 bytes"
        End Try
    End Function

End Class
	 