﻿' CharMap, Version 2.0.0, vom 02.09.2010
'
' Erweitert das Context-Menü der "Eigenschaft: Text"
' um einen Eintrag zum Aufrufen der Windows Zeichensatztabelle
'
'
' Copyright by Frank Schöneck, 2010
'
' für Eplan Electric P8, ab V2.0.5
'
Public Class CharMap
 <DeclareMenu()> _
  Public Sub DeleteProjectBackup_Menu()
    'Menüeintrag
    Dim oMenu As New Eplan.EplApi.Gui.Menu()
    oMenu.AddMenuItem("Zei&chensatztabelle öffnen...", "CharMapMenu", "Es wird die Windows Zeichsatztabelle aufgerufen", 35032, 1, True, False)

		'Context-Menüeintrag (hier in der Seitenübersicht)
		Dim oContextMenu As New Eplan.EplApi.GUI.ContextMenu()
		Dim oContextMenuLocation As New Eplan.EplApi.GUI.ContextMenuLocation("GedEditGuiText", "1002")
		oContextMenu.AddMenuItem(oContextMenuLocation, "Zeichensatztabelle öffnen...", "CharMapMenu", True, False)
  End Sub

  <DeclareAction("CharMapMenu")> _
 Public Sub CharMapMenu()
		
    Dim sCharMap As String = "system32\charmap.exe"
    Dim sWinDir As String = Environment.GetEnvironmentVariable("windir")
    If sWinDir.EndsWith("\") = False Then sWinDir &= "\"
		
    Dim ExterneAnwendung As New System.Diagnostics.Process()
    Dim Argumente As String = ""
    ExterneAnwendung.StartInfo.FileName = sWinDir & sCharMap
    ExterneAnwendung.StartInfo.Arguments = Argumente
    ExterneAnwendung.StartInfo.UseShellExecute = True
    ExterneAnwendung.StartInfo.CreateNoWindow = False
    ExterneAnwendung.Start()
		
    Return
		
  End Sub 'CharMapMenu

 End Class
