﻿' PDFbyProjectClose, Version 2.1.0, vom 14.04.2009
'
' Beim schließen eines Projektes wird automatisch eine
' PDF-Datei mit Projektnamen angelegt.
'
' Copyright by Frank Schöneck, 2008
' letzte Änderung: nairolf       , 04.12.2008 V1.1.0, Projekt-Ordner ermitteln
'                  Frank Schöneck, 15.01.2009 V1.2.0, Auswahl Ausgabe-Ordner
'                  Frank Schöneck, 26.01.2009 V1.3.0, Progressbar hinzugefügt
'                  Frank Schöneck, 14.04.2009 V2.0.0, Neue Funktionen für Projektname + Pfad
'                  Johann Weiher,  12.03.2010 V2.1.0, Neue Funktionen für Speicherort frei wählbar
'
' für Eplan Electric P8, ab V1.9.5
'
'
Public Class PDFbyProjectClose
    <DeclareEventHandler("onActionStart.String.XPrjActionProjectClose")> _
     Public Function MyEventHandlerFunction(ByVal iEventParameter As IEventParameter) As Long

        'MessageBox.Show("Projekt schließen wurde gestartet!")
        Dim strPDFDatei As String
        Dim strProjektOrdner As String
        Dim strAusgabeOrdner As String
        Dim AusgabeNach As Integer
				
        'Hier einstellen wohin die PDF-Datei gespeichert werden soll!
        '1 = in den Projekt-Ordner
        '2 = in den Ordner eine Ebene über dem Projekt-Ordner
        '3 = in Ordner "Eigene Dateien"
        '4 = auf den Desktop
        '5 = Speicherort manuell wählen

        AusgabeNach = 5 '<-- hier einstellen
				
        strProjektOrdner = PathMap.SubstitutePath("$(PROJECTPATH)")
        Select Case AusgabeNach
            Case 1
                'in den Projekt-Ordner
                strAusgabeOrdner = strProjektOrdner
            Case 2
                'in den Ordner eine Ebene über dem Projekt-Ordner
                strAusgabeOrdner = strProjektOrdner.Substring(0, strProjektOrdner.LastIndexOf("\"))
            Case 3
                'in Ordner "Eigene Dateien"
                strAusgabeOrdner = Environment.GetFolderPath(Environment.SpecialFolder.Personal)
            Case 4
                'in Ordner "Desktop"
                strAusgabeOrdner = Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory)
            Case 5
                Dim FolderBrowserDialog1 As New FolderBrowserDialog
                With FolderBrowserDialog1
                    .RootFolder = Environment.SpecialFolder.Desktop
                    .Description = "Zielordner:"
                    If .ShowDialog = DialogResult.OK Then
                        ' Display the selected folder if the user clicked on the OK button.
                        strAusgabeOrdner = .SelectedPath
                    End If
                End With

            Case Else
                MessageBox.Show("Variable 'AusgabeNach' wurde nicht korrekt eingestellt.", "PDFbyProjectClose", MessageBoxButtons.OK, MessageBoxIcon.Error)
                Exit Function
        End Select
	
        strPDFDatei = strAusgabeordner & "\" & PathMap.SubstitutePath("$(PROJECTNAME)") & ".pdf"
        'MessageBox.Show(strPDFDatei)
        PDFexport(strPDFDatei)

        Return 0
    End Function 'MyEventHandlerFunction
		
    Public Sub PDFexport(ByVal strZielDatei As String)
        'Gesamtes Projekt als PDF ausgeben
				'Progressbar ein
				Dim oProgress as New Eplan.EplApi.Base.Progress("SimpleProgress")
				oProgress.ShowImmediately
				
        Dim pdfContext As New ActionCallingContext()
        pdfContext.AddParameter("TYPE", "PDFPROJECT")
        pdfContext.AddParameter("EXPORTFILE", strZielDatei) 'Name export.Projekt, Vorgabewert: Projektname
        pdfContext.AddParameter("USEZOOMLEVEL", "1") 'Springen in Navigationsseiten
        pdfContext.AddParameter("ZOOMLEVEL", "1") 'wenn USEZOOMLEVEL auf 1 dann hier Zoomstufe in mm
        pdfContext.AddParameter("USESIMPLELINK", "1") '1 = einfache Sprungfunktion
        pdfContext.AddParameter("FASTWEBVIEW", "1") '1 = schnelle Web-Anzeige
        pdfContext.AddParameter("READONLYEXPORT", "2") '1 = PDF wird schreibgeschützt
        pdfContext.AddParameter("BLACKWHITE", "1") '1 = PDF wird schwarz-weiss

        Dim CommandLineInterpreter As New CommandLineInterpreter()
        CommandLineInterpreter.Execute("export", pdfContext)
				
				'Progressbar aus
				oProgress.EndPart(True)
				
        Return
    End Sub

End Class
	 